/*
-- Program : NOME
-- Author : Nguoc Tran Nguyen
-- Email : nome-feedback@lexum.umontreal.ca
-- Creation date : 2005-11-07

Copyright (C) 2005 LexUM, RALI - Universit de Montral

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details. http://www.gnu.org/copyleft/gpl.html

You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/ 

// Setting.cpp : fichier d'implmentation
//

#include "stdafx.h"
#include "nome.h"
#include "Setting.h"
#include "NomeTabDlg.h"
#include "MyGrid.h"
#include ".\setting.h"

// Bote de dialogue CSetting
extern GETCOLOR getColor;

IMPLEMENT_DYNAMIC(CSetting, CTabDlg)
CSetting::CSetting(CWnd* pParent /*=NULL*/)
	: CTabDlg(CSetting::IDD, pParent)
{
}

CSetting::~CSetting()
{
}

void CSetting::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_INCLUSION, m_inclusion);
	DDX_Control(pDX, IDC_EXCLUSION, m_exclusion);
	DDX_Control(pDX, IDC_TITLE, m_title);
	DDX_Control(pDX, IDC_NORMAL_COLOR, m_NormalColor);
	DDX_Control(pDX, IDC_INCLUSION_COLOR, m_IncColor);
	DDX_Control(pDX, IDC_MANUAL_COLOR, m_ManualColor);
	DDX_Control(pDX, IDC_SAME_COLOR, m_SameColor);
}

BEGIN_MESSAGE_MAP(CSetting, CDialog)
	ON_BN_CLICKED(IDC_INCLUSION, OnBnClickedInclusion)
	ON_BN_CLICKED(IDC_EXCLUSION, OnBnClickedExclusion)
	ON_BN_CLICKED(IDC_TITLE, OnBnClickedTitle)
	ON_BN_CLICKED(IDC_APPLY, OnBnClickedApply)
	ON_BN_CLICKED(IDC_INCLUSION_COLOR, OnBnClickedInclusionColor)
	ON_BN_CLICKED(IDC_MANUAL_COLOR, OnBnClickedManualColor)
	ON_WM_SIZE()
	ON_BN_CLICKED(IDC_NORMAL_COLOR, OnBnClickedNormalColor)
	ON_BN_CLICKED(IDC_RENGLISH, OnBnClickedRenglish)
	ON_BN_CLICKED(IDC_RFRENCH, OnBnClickedRfrench)
	ON_BN_CLICKED(IDC_RESET, OnBnClickedReset)
	ON_BN_CLICKED(IDC_RREPFRENCH, OnBnClickedRrepfrench)
	ON_BN_CLICKED(IDC_RREPENGLISH, OnBnClickedRrepenglish)
	ON_BN_CLICKED(IDC_SAME_COLOR, OnBnClickedSameColor)
END_MESSAGE_MAP()
// Gestionnaires de messages CSetting

void CSetting::OnBnClickedInclusion()
{
	char szFilters[]=
      "inclusion file (*.doc)|*.doc|All Files (*.*)|*.*||";
	CFileDialog fileDlg (TRUE, "inclusion file", strIncl,
      OFN_FILEMUSTEXIST| OFN_HIDEREADONLY, szFilters );
	TCHAR buffer[2000];
	if( fileDlg.DoModal ()==IDOK )
	{
		tempIncl = fileDlg.GetPathName();
		reduceString(tempIncl, buffer);
		m_inclusion.SetWindowText(buffer);
		strIncl = tempIncl;
		((CNomeTabDlg*)GetParent())->invokeNome(NOME_OPEN_DOC_INCLUSION);
	}	
}

void CSetting::OnBnClickedExclusion()
{
	// TODO: Add your control notification handler code here
	char szFilters[]=
      "exclusion file (*.doc)|*.doc|All Files (*.*)|*.*||";
	CFileDialog fileDlg (TRUE, "exclusion file", strExcl,
      OFN_FILEMUSTEXIST| OFN_HIDEREADONLY, szFilters);
	TCHAR buffer[2000];
	if( fileDlg.DoModal ()==IDOK )
	{
		tempExcl= fileDlg.GetPathName();
		reduceString(tempExcl, buffer);
		m_exclusion.SetWindowText(buffer);
		strExcl = tempExcl;
		((CNomeTabDlg*)GetParent())->invokeNome(NOME_OPEN_DOC_EXCLUSION);
	}
}

void CSetting::OnBnClickedTitle()
{
	// TODO: Add your control notification handler code here
	char szFilters[]=
      "title file (*.doc)|*.doc|All Files (*.*)|*.*||";
	CFileDialog fileDlg (TRUE, "inclusion file", strTitle,
      OFN_FILEMUSTEXIST| OFN_HIDEREADONLY, szFilters);   
	TCHAR buffer[2000];
	if( fileDlg.DoModal ()==IDOK )
	{
		tempTitle= fileDlg.GetPathName();
		reduceString(tempTitle, buffer);
		m_title.SetWindowText(buffer);
		strTitle = tempTitle;
		((CNomeTabDlg*)GetParent())->invokeNome(NOME_OPEN_DOC_TITLE);
	}	
}

void CSetting::initTab()
{	
	CNomeTabDlg* dlg = (CNomeTabDlg*)GetParent();
}
void CSetting::OnBnClickedApply()
{
	// TODO: Add your control notification handler code here
	CNomeTabDlg* dlg = (CNomeTabDlg*)GetParent();
	strIncl = tempIncl;
	strExcl = tempExcl;
	strTitle = tempTitle;	
	dlg->invokeNome(NOME_APPLYSETTING);//set text color global	
	dlg->invokeNome(NOME_SET_LANG, dlg->lang);// set langage global
	dlg->invokeNome(NOME_SET_REP_LANG, dlg->repLang);//set rep_lang global

/*	dlg->m_Replacement.typeColor[CReplacement::ntNormal] = m_NormalColor.GetColor();

	dlg->m_Replacement.typeColor[CReplacement::ntIncluded] = m_IncColor.GetColor();

	dlg->m_Replacement.typeColor[CReplacement::ntManual] = m_ManualColor.GetColor();

	dlg->m_Replacement.typeColor[CReplacement::ntSame] = m_SameColor.GetColor();*/
}
SAFEARRAY* CSetting::getParameters()
{
	SAFEARRAY* paras;
	SAFEARRAYBOUND rgsabound;
	rgsabound.lLbound = 0;
	rgsabound.cElements = 3;
	paras = SafeArrayCreate(VT_BSTR, 1, &rgsabound);
	if(paras == NULL) return NULL;
	long i = 0;
	SafeArrayPutElement(paras, &i,strIncl.AllocSysString());
	i = 1;
	SafeArrayPutElement(paras, &i,strExcl.AllocSysString());
	i = 2;
	SafeArrayPutElement(paras, &i,strTitle.AllocSysString());
	return paras;
}
SAFEARRAY* CSetting::getTextColors()
{
	SAFEARRAY* paras;
	SAFEARRAYBOUND rgsabound;
	rgsabound.lLbound = 0;
	rgsabound.cElements = 4;
	paras = SafeArrayCreate(VT_I4, 1, &rgsabound);
	if(paras == NULL) return NULL;
	long i = 0;
	int value;
	CString temp;
	value = (int)m_NormalColor.GetColor();
	SafeArrayPutElement(paras, &i, (void*)&value);
	i = 1;
	value = (int)m_IncColor.GetColor();
	SafeArrayPutElement(paras, &i, (void*)&value);
	i = 2;
	value = (int)m_ManualColor.GetColor();
	SafeArrayPutElement(paras, &i, (void*)&value);
	i = 3;
	value = (int)m_SameColor.GetColor();
	SafeArrayPutElement(paras, &i, (void*)&value);
	return paras;
}
int CSetting::setTextColors(int normal, int included, 
						   int manual, int same)
{
	
	CNomeTabDlg* dlg = (CNomeTabDlg*)GetParent();
	//_stscanf(normal, _T("%u"), &color);
	m_NormalColor.SetColor((COLORREF)normal);
	//_stscanf(included, _T("%u"), &color);
	m_IncColor.SetColor((COLORREF)included);
	//_stscanf(manual, _T("%u"), &color);
	m_ManualColor.SetColor((COLORREF)manual);
	//_stscanf(same, _T("%u"), &color);
	m_SameColor.SetColor((COLORREF)same);

	dlg->m_Replacement.typeColor[CReplacement::ntNormal] = m_NormalColor.GetColor();

	dlg->m_Replacement.typeColor[CReplacement::ntIncluded] = m_IncColor.GetColor();

	dlg->m_Replacement.typeColor[CReplacement::ntManual] = m_ManualColor.GetColor();

	dlg->m_Replacement.typeColor[CReplacement::ntSame] = m_SameColor.GetColor();

	return 0;
}
int CSetting::setParameters(LPCTSTR incl, LPCTSTR excl, LPCTSTR title)
{
	strIncl.SetString(incl);
	strExcl.SetString(excl);
	strTitle.SetString(title);
	tempIncl = strIncl;
	tempExcl = strExcl;
	tempTitle = strTitle;
	TCHAR buffer[2000];
	reduceString(strIncl, buffer);
	m_inclusion.SetWindowText(buffer);
	reduceString(strExcl, buffer);
	m_exclusion.SetWindowText(buffer);
	reduceString(strTitle, buffer);
	m_title.SetWindowText(buffer);
	return 0;
}
void CSetting::reduceString(CString &str, TCHAR* buffer)
{
	int curPos= 0;
	CString resToken;
	CString out("");
	BOOL deleted = false;
	CString pre;
	resToken= str.Tokenize("\\",curPos);
	while (resToken != "")
	{
		if (resToken.GetLength()+ out.GetLength() <=25){
			if (out.GetLength() > 0) out.Append("\\"); 
			out.Append(resToken);
		}
		else deleted = true;
		pre = resToken;
		resToken = str.Tokenize("\\",curPos);
	};
	if (deleted) out.Append("\\...\\" + pre);
	_tcscpy(buffer,out);
}
void CSetting::OnBnClickedInclusionColor()
{
	CNomeTabDlg* dlg = (CNomeTabDlg*)GetParent();
	dlg->m_Replacement.typeColor[CReplacement::ntIncluded] = m_IncColor.GetColor();
}

void CSetting::OnBnClickedManualColor()
{
	CNomeTabDlg* dlg = (CNomeTabDlg*)GetParent();
	dlg->m_Replacement.typeColor[CReplacement::ntManual] = m_ManualColor.GetColor();	
}

void CSetting::OnSize(UINT nType, int cx, int cy)
{
}

void CSetting::OnBnClickedNormalColor()
{
	CNomeTabDlg* dlg = (CNomeTabDlg*)GetParent();
	dlg->m_Replacement.typeColor[CReplacement::ntNormal] = m_NormalColor.GetColor();
}

void CSetting::OnBnClickedRenglish()
{
	// TODO: Add your control notification handler code here
	CNomeTabDlg* dlg = (CNomeTabDlg*)GetParent();
	dlg->changeLang(NOME_ENGLISH);
}
void CSetting::changeLang(int lang)
{
	TCHAR buffer[1000];
	HINSTANCE hInstance = (HINSTANCE) GetModuleHandle ("nome.dll");
	LoadString(hInstance, IDS_SETTING_EN + lang, buffer, 1000);
	SetWindowText(buffer);
	
	((CButton*)GetDlgItem(IDC_RENGLISH))->SetCheck((lang == NOME_ENGLISH)? BST_CHECKED:BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_RFRENCH))->SetCheck((lang == NOME_FRENCH)? BST_CHECKED:BST_UNCHECKED);

	LoadString(hInstance, IDS_ENGLISH_EN + lang, buffer, 1000);
	GetDlgItem(IDC_RENGLISH)->SetWindowText(buffer);
	LoadString(hInstance, IDS_FRENCH_EN + lang, buffer, 1000);
	GetDlgItem(IDC_RFRENCH)->SetWindowText(buffer);


	LoadString(hInstance, IDS_RESET_EN + lang, buffer, 1000);
	GetDlgItem(IDC_RESET)->SetWindowText(buffer);
	LoadString(hInstance, IDS_APPLY_EN + lang, buffer, 1000);
	GetDlgItem(IDC_APPLY)->SetWindowText(buffer);

	LoadString(hInstance, IDS_LANGUAGES_EN + lang, buffer, 1000);
	GetDlgItem(IDC_SLANGUAGES)->SetWindowText(buffer);

	LoadString(hInstance, IDS_FILES_EN + lang, buffer, 1000);
	GetDlgItem(IDC_SFILES)->SetWindowText(buffer);
	LoadString(hInstance, IDS_COLOR_EN + lang, buffer, 1000);
	GetDlgItem(IDC_SCOLORS)->SetWindowText(buffer);

	LoadString(hInstance, IDS_NORMAL_EN + lang, buffer, 1000);
	GetDlgItem(IDC_SNORMAL)->SetWindowText(buffer);
	LoadString(hInstance, IDS_INCLUSION_EN + lang, buffer, 1000);
	GetDlgItem(IDC_SINCLUSION)->SetWindowText(buffer);
	LoadString(hInstance, IDS_MANUAL_EN + lang, buffer, 1000);
	GetDlgItem(IDC_SMANUAL)->SetWindowText(buffer);

	LoadString(hInstance, IDS_SAME_COLOR_EN + lang, buffer, 1000);
	GetDlgItem(IDC_SSAMEINITIAL)->SetWindowText(buffer);

	LoadString(hInstance, IDS_REPLACEMENT_EN + lang, buffer, 1000);
	GetDlgItem(IDC_SREPLACEMENT)->SetWindowText(buffer);

	LoadString(hInstance, IDS_TITLE_EN + lang, buffer, 1000);
	GetDlgItem(IDC_STITLE)->SetWindowText(buffer);

}

void CSetting::OnBnClickedRfrench()
{
	// TODO: Add your control notification handler code here
	CNomeTabDlg* dlg = (CNomeTabDlg*)GetParent();
	dlg->changeLang(NOME_FRENCH);
}

void CSetting::OnBnClickedReset()
{
	// TODO: Add your control notification handler code here
	CNomeTabDlg* dlg = (CNomeTabDlg*)GetParent();
	dlg->invokeNome(NOME_RESETSETTING);//set text color global	
}

void CSetting::OnBnClickedSavestyle()
{
}
void CSetting::changeRepLang(int lang)
{
	((CButton*)GetDlgItem(IDC_RREPENGLISH))->SetCheck((lang == NOME_ENGLISH)? BST_CHECKED:BST_UNCHECKED);
	((CButton*)GetDlgItem(IDC_RREPFRENCH))->SetCheck((lang == NOME_FRENCH)? BST_CHECKED:BST_UNCHECKED);
}
void CSetting::OnBnClickedRrepfrench()
{
	// TODO: Add your control notification handler code here
	CNomeTabDlg* dlg = (CNomeTabDlg*)GetParent();
	dlg->changeRepLang(NOME_FRENCH);
}

void CSetting::OnBnClickedRrepenglish()
{
	// TODO: Add your control notification handler code here
	CNomeTabDlg* dlg = (CNomeTabDlg*)GetParent();
	dlg->changeRepLang(NOME_ENGLISH);
}

void CSetting::OnBnClickedSameColor()
{
	// TODO: Add your control notification handler code here
	CNomeTabDlg* dlg = (CNomeTabDlg*)GetParent();
	dlg->m_Replacement.typeColor[CReplacement::ntSame] = m_SameColor.GetColor();
}
