/*
-- Program : NOME
-- Author : Nguoc Tran Nguyen
-- Email : nome-feedback@lexum.umontreal.ca
-- Creation date : 2005-11-07

Copyright (C) 2005 LexUM, RALI - Universit de Montral

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details. http://www.gnu.org/copyleft/gpl.html

You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/ 

#include "stdafx.h"
#include "MyGrid.h"
#include "resource.h"

#include "NomeTabDlg.h"
#include <Afxwin.h>
#include <Afxtempl.h>

static CMapWordToPtr dlgs;
static WORD counter = 0;
NOTIFYNOME notifyNome = NULL;
INVOKENOME invokeNome = NULL;
GETCOLOR getColor = NULL;
WNDPROC docFunc;
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

//Keys, long lpInvokeNomePos
MYDLLFUNCTION int _stdcall connectNome(long lpNotifyNome, long lpInvokeNome, long lpGetColor){
	notifyNome = (NOTIFYNOME)lpNotifyNome;
	invokeNome = (INVOKENOME)lpInvokeNome;
	getColor = (GETCOLOR)lpGetColor;	
	return 0;
}
MYDLLFUNCTION int _stdcall isNomeCharAlphaNumeric(LPTSTR text)
{
	return (IsCharAlphaNumeric(text[0]))? 1: 0; 
}

MYDLLFUNCTION int _stdcall startNome(int id)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	pDlg->invokeNome(NOME_ANALYZE,-1); 
	return 0;
}
MYDLLFUNCTION int _stdcall setLang(int id, int lang)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	pDlg->changeLang(lang); 
	return 0;
}
MYDLLFUNCTION int _stdcall setRepLang(int id, int lang)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	pDlg->changeRepLang(lang); 
	return 0;
}
MYDLLFUNCTION int _stdcall selectRowByName(int id, LPTSTR name)
{
	//save time do whatever to get it working
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	int row = pDlg->findName(name, 3);	
	return (row >=1)? selectRow(id, row):0;
}
MYDLLFUNCTION int _stdcall setPos(int id, LPTSTR str, int pos)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	if (pDlg != NULL){
		pDlg->setProgressPos(str, pos); 
	}
	return 0;
}
MYDLLFUNCTION int _stdcall createNome(HWND id, HWND parent=NULL, BOOL modal = true, BOOL visible= true)
{	
	CNomeTabDlg* pDlg;
	pDlg = new CNomeTabDlg();
	if (modal){
		pDlg->DoModal();
		delete pDlg;
		pDlg = NULL;
		return -1;
	}
	else{
		pDlg->Create(CNomeTabDlg::IDD);
		SetParent(pDlg->m_hWnd, parent);
		if (visible) pDlg->ShowWindow(SW_SHOW);
		else pDlg->ShowWindow(SW_HIDE);
		pDlg->id = id;
		pDlg->myID = counter;
		dlgs[counter] = pDlg;
		counter++;
		return counter - 1; 
	}
}
MYDLLFUNCTION int _stdcall deleteAll()
{
	POSITION pos;
	WORD key;
	VOID* pDlg;
	for( pos = dlgs.GetStartPosition(); pos != NULL; )
	{
		dlgs.GetNextAssoc(pos, key, pDlg);
		delete (CNomeTabDlg*)pDlg;
    }
	dlgs.RemoveAll();
	return 0;
}
MYDLLFUNCTION int _stdcall setColor (int id, int row, int type)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	return pDlg->m_Replacement.setRowColor(row, type);
}
MYDLLFUNCTION int _stdcall selectRow(int id, int row)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	pDlg->m_Replacement.m_Grid.EnsureVisible(row, 0); 
	return pDlg->m_Replacement.selectRowByIndex(row);
}

MYDLLFUNCTION int _stdcall deleteNome(int id)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	if (pDlg  != NULL){
		delete pDlg;
		dlgs.RemoveKey(id); 
	}
	return 0;
}
MYDLLFUNCTION int _stdcall removeAllWords(int id)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	if (pDlg != NULL)
		pDlg->m_Replacement.removeAllRows();
	return 0;
}
MYDLLFUNCTION HWND _stdcall getWindowHandle(int id)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	return (pDlg != NULL)? pDlg->m_hWnd: NULL;
}
MYDLLFUNCTION int _stdcall setText(int id, int row, int column, LPTSTR text)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	pDlg->m_Replacement.m_Grid.SetItemText(row, column, text);
	return 0;
}
MYDLLFUNCTION BSTR _stdcall getText(int id, int row, int column)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	CString str = pDlg->m_Replacement.m_Grid.GetItemText(row, column);
	BSTR bstr = str.AllocSysString();
	return bstr;
}
MYDLLFUNCTION SAFEARRAY* _stdcall  getSelectedKeys(int id, BOOL deleted)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	return pDlg->getSelectedNamesKeys(deleted); 
}
MYDLLFUNCTION SAFEARRAY* _stdcall  getSelectedPos(int id, int type, BOOL deleted)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	return pDlg->getSelectedNamesPos(type, deleted); 
}
MYDLLFUNCTION BOOL _stdcall  isChecked(int id, int row)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	return pDlg->isNameChecked(row);
}
MYDLLFUNCTION int _stdcall resizeGrid(int id)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	return pDlg->getAutoSize(); 
}
MYDLLFUNCTION int _stdcall addWord(int id, int nCounts, LPTSTR words, LPTSTR replacement, int type)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	return pDlg->addRow(nCounts, words, replacement, type);
}
MYDLLFUNCTION int _stdcall deleteSelection(int id)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	pDlg->deleteSelectedRows();
	return 0;
}
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int temp;
	switch (message) 
	{
		case WM_CLOSE:
			//MessageBox(NULL, "TRAN","NOME",MB_OK);
			return CallWindowProc(docFunc, hWnd, message, wParam, lParam);
		default:
			return CallWindowProc(docFunc, hWnd, message, wParam, lParam);
	}
}

MYDLLFUNCTION SAFEARRAY* _stdcall getSettingColors(int id)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	return pDlg->m_Setting.getTextColors();
}
MYDLLFUNCTION int _stdcall setSettingColors(int id, int normal, int included, int manual, int same)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	return pDlg->m_Setting.setTextColors( normal, included, 
											manual, same);
}

MYDLLFUNCTION SAFEARRAY* _stdcall getParameterFiles(int id)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	return pDlg->m_Setting.getParameters();
}

MYDLLFUNCTION int _stdcall setParameterFiles(int id, LPTSTR inc, LPTSTR exc, LPTSTR title)
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*)dlgs[id];
	return pDlg->m_Setting.setParameters(inc, exc, title);
}
