/*
-- Program : NOME
-- Author : Nguoc Tran Nguyen
-- Email : nome-feedback@lexum.umontreal.ca
-- Creation date : 2005-11-07

Copyright (C) 2005 LexUM, RALI - Universit de Montral

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details. http://www.gnu.org/copyleft/gpl.html

You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/ 

// NomeButton.cpp : implementation file
//

#include "stdafx.h"
#include "nome.h"
#include "NomeButton.h"
#include "afxstr.h"
#include  "atlimage.h"
#include ".\nomebutton.h"


// CNomeButton

IMPLEMENT_DYNAMIC(CNomeButton, CButton)
CNomeButton::CNomeButton()
{
	type = 0;
}

CNomeButton::~CNomeButton()
{
}


BEGIN_MESSAGE_MAP(CNomeButton, CButton)
	ON_WM_MOUSEMOVE()
END_MESSAGE_MAP()

// CNomeButton message handlers
void CNomeButton::SetImage(UINT id, COLORREF transColor)
{
	hBitmap.LoadBitmap(id);
	clrTrans = transColor;
	Invalidate(false);
}
void CNomeButton::SetUnderColor(COLORREF color)
{
	underColor = color;
	Invalidate(FALSE);
}

void CNomeButton::SetTooltipId(int id) 
{
	this->id = id;
}
void CNomeButton::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
   UINT uStyle = DFCS_BUTTONPUSH;

   // This code only works with buttons.
   ASSERT(lpDrawItemStruct->CtlType == ODT_BUTTON);

   // If drawing selected, add the pushed style to DrawFrameControl.
   if (lpDrawItemStruct->itemState & ODS_SELECTED)
      uStyle |= DFCS_PUSHED;

   // Draw the button frame.
   ::DrawFrameControl(lpDrawItemStruct->hDC, &lpDrawItemStruct->rcItem, 
      DFC_BUTTON, uStyle);

    CClientDC dc(this);
    CRect rect;
	GetClientRect(&rect);
	rect.DeflateRect(2,2);
	
//	dc.FillSolidRect(&rect,	::GetSysColor(COLOR_BTNFACE));
		
   // Get the button's text.
	if ((HBITMAP)hBitmap!= NULL){
		HDC memDC = ::CreateCompatibleDC(lpDrawItemStruct->hDC);
		BITMAP image;
		HGDIOBJ old = ::SelectObject(memDC, (HBITMAP)hBitmap);
		hBitmap.GetBitmap(&image);
		if (type){//draw highlight color for hightlight button
			
		}
		::TransparentBlt(lpDrawItemStruct->hDC,(rect.Width() -image.bmWidth )/2, (rect.Height() -image.bmHeight)/2,
			image.bmWidth ,image.bmHeight , memDC,0,0,image.bmWidth ,image.bmHeight , clrTrans);
		::SelectObject(memDC, old);
		DeleteDC(memDC);
	}
}



void CNomeButton::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	NB_TOOLTIP nbTooltip;
	nbTooltip.hdr.code = NOMEBUTTON_TOOLTIP;
	nbTooltip.hdr.hwndFrom = m_hWnd;
	nbTooltip.hdr.idFrom =GetDlgCtrlID();
	nbTooltip.id = id;	
	CWnd* parent = GetParent();

	parent->SendMessage(WM_NOTIFY,GetDlgCtrlID() , (LPARAM)&nbTooltip);
}
