#pragma once
#include "GridCtrl_src\gridctrl.h"
#include "afxcmn.h"
#include "afxwin.h"
#include "TabDlg.h"
#include "ColorBox.h"
#include "ColorButton.h"
#include "NomeButton.h"
//#include "ToolTipEx_src\OxTooltipCtrl.h"

// Bote de dialogue CNomeDialog
template<> 
AFX_INLINE UINT AFXAPI HashKey<CString> (CString strKey)
{
	LPCSTR key = strKey;
	UINT nHash = 0;
	while (*key)
	{
		nHash = (nHash<<5) + nHash + *key++;
	}
	return nHash;
}

class CReplacement : public CTabDlg
{
	DECLARE_DYNAMIC(CReplacement)
public:
	enum { ntNormal,ntIncluded,ntManual, ntSame};
/*  wdAuto = 0x00000000,
  wdBlack = 0x00000001,
  wdBlue = 0x00000002,
  wdTurquoise = 0x00000003,
  wdBrightGreen = 0x00000004,
  wdPink = 0x00000005,
  wdRed = 0x00000006,
  wdYellow = 0x00000007,
  wdWhite = 0x00000008,
  wdDarkBlue = 0x00000009,
  wdTeal = 0x0000000A,
  wdGreen = 0x0000000B,
  wdViolet = 0x0000000C,
  wdDarkRed = 0x0000000D,
  wdDarkYellow = 0x0000000E,
  wdGray50 = 0x0000000F,
  wdGray25 = 0x00000010,
  wdByAuthor = 0xFFFFFFFF,
  wdNoHighlight = 0x00000000
};*/
	CReplacement(CWnd* pParent = NULL);   // constructeur standard
	virtual ~CReplacement();
// Donnes de bote de dialogue
	enum { IDD = IDD_REPLACEMENT };
	CImageList imageList;
	int rowCombo;// the row contains the combox box -1 if no column contains combobox	
protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	DECLARE_MESSAGE_MAP()
public:
	CGridCtrl m_Grid;
	COLORREF typeColor[5];
	virtual BOOL OnInitDialog();
	BOOL PreTranslateMessage(MSG* pMsg);
	CMap <CString,CString,int,int> reps;
//	afx_msg void OnSize(UINT nType, int cx, int cy);
	int addRow(int nCount, LPTSTR string, LPTSTR replacement, int type);
	int setRowColor(int row, int type);
	int selectRowByIndex(int row);
	BOOL selectSameRep(int nRows, LPTSTR rep);
	//BOOL OnToolTipNotify(UINT id, NMHDR* pNMHDR, LRESULT* pResult);
	BOOL selectSameRep(int nRows, CString str);
	
	void initTab();
	void changeLang(int);
	int removeAllRows();
	BOOL updateSameReplacement();
	void resizeDock();
	CNomeButton m_Analyse, m_Plus, m_Minus, m_Dock, m_Next, m_Previous;
	CNomeButton m_AcceptM, m_RemoveM, m_Conflict;
	CNomeButton m_Replace, m_Highlight;
	//CColorButton m_Replace;
	//CColorButton m_Highlight; 

	BOOLEAN m_Checked;

	//CToolTipCtrl tooltip;
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnBnClickedBanalyse();
	afx_msg void OnBnClickedBreplace();
	afx_msg void OnBnClickedBhighlight();
	afx_msg void OnBnClickedBremove();
	afx_msg void OnGridEndSelChange(NMHDR *pNotifyStruct, LRESULT* pResult);
	afx_msg BOOL OnNBTooltip(UINT id, NMHDR *pNotifyStruct, LRESULT* pResult);
	afx_msg void OnGridEndEdit(NMHDR *pNotifyStruct, LRESULT* pResult);
	afx_msg void OnGridStartEdit(NMHDR *pNotifyStruct, LRESULT* pResult);
	afx_msg void OnGridClick(NMHDR *pNotifyStruct, LRESULT* pResult);	
	afx_msg void OnBnClickedBprevious();
	afx_msg void OnBnClickedBnext();
	afx_msg void OnBnClickedBwhere();
	afx_msg void OnBnClickedBadd();
	afx_msg void OnBnClickedBdock();
	afx_msg void OnBnClickedBconflict();
	afx_msg void OnBnClickedBremovem();
	afx_msg void OnBnClickedAcceptm();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	int lang;
};
