#ifndef _MYGRID_H
#define _MYGRID_H
#ifdef MYIMPORT
#define MYDLLFUNCTION __declspec(dllimport)
#else
#define MYDLLFUNCTION __declspec(dllexport)
#endif

#include <atlbase.h>
#include <oleauto.h>
#include <tchar.h>

#define NOME_REPLACE 0x0001
#define NOME_HIGHLIGHT 0x0002
#define NOME_ANALYZE 0x0003
#define NOME_REMOVE 0x0004
#define NOME_NEXT 0x0005
#define NOME_PREVIOUS 0x0006
#define NOME_WHERE 0x0007
#define NOME_APPLYSETTING 0x0008
#define NOME_ADD 0x0009
#define NOME_DOCK 0x000A
#define NOME_OPEN_DOC_INCLUSION 0x000B
#define NOME_OPEN_DOC_EXCLUSION 0x000C
#define NOME_OPEN_DOC_TITLE 0x000D
#define NOME_SET_LANG 0x000E
#define NOME_SET_SAVE_STYLE 0x000F
#define NOME_SET_REP_LANG 0x0010
#define NOME_ACCEPTM 0x0011
#define NOME_REMOVEM 0x0012
#define NOME_RESETSETTING 0x0014

#define NOME_ENGLISH 0x0000
#define NOME_FRENCH 0x0001

typedef int (_stdcall *NOTIFYNOME)(UINT msg, HWND parent);
typedef int (_stdcall *INVOKENOME)(UINT msg, HWND parent, int param1);
typedef int (_stdcall *GETCOLOR)(HWND parent, int index);

MYDLLFUNCTION int _stdcall connectNome(long lpNotifyNome, long lpInvokeNome, long lpGetColor);
MYDLLFUNCTION int _stdcall setPos(int id, LPTSTR str, int pos);
MYDLLFUNCTION int _stdcall isNomeCharAlphaNumeric(LPTSTR text);

MYDLLFUNCTION BOOL _stdcall  isChecked(int id, int row);
MYDLLFUNCTION int _stdcall createNome(HWND id, HWND parent, BOOL modal, BOOL visible);
MYDLLFUNCTION int _stdcall deleteNome(int id);
MYDLLFUNCTION int _stdcall setText(int id, int row, int column, LPTSTR text);
MYDLLFUNCTION int _stdcall addWord(int id, int nCounts, LPTSTR words, LPTSTR replacement, int type = 0);
MYDLLFUNCTION int _stdcall setColor(int id, int row, int type);
MYDLLFUNCTION int _stdcall selectRow(int id, int row);
MYDLLFUNCTION int _stdcall selectRowByName(int id, LPTSTR str);
MYDLLFUNCTION int _stdcall resizeGrid(int id);
MYDLLFUNCTION int _stdcall removeAllWords(int id);
MYDLLFUNCTION HWND _stdcall getWindowHandle(int id);
MYDLLFUNCTION int _stdcall deleteAll();
MYDLLFUNCTION BSTR _stdcall getText(int id, int row, int column);
MYDLLFUNCTION SAFEARRAY* _stdcall  getSelectedKeys(int id, BOOL deleted);
MYDLLFUNCTION SAFEARRAY* _stdcall  getSelectedPos(int id, int type, BOOL deleted);
MYDLLFUNCTION int _stdcall deSelectAll(int id);
MYDLLFUNCTION SAFEARRAY* _stdcall getParameterFiles(int id);
MYDLLFUNCTION int _stdcall setParameterFiles(int id, LPTSTR incl, LPTSTR excl, LPTSTR title);
MYDLLFUNCTION SAFEARRAY* _stdcall getSettingColors(int id);
MYDLLFUNCTION int _stdcall setSettingColors(int id, int normal, int included, int manual, int same);

MYDLLFUNCTION int _stdcall setLang(int id, int lang);
MYDLLFUNCTION int _stdcall setRepLang(int id, int lang);
MYDLLFUNCTION int _stdcall startNome(int id);
#endif