// ColorButton.cpp : implementation file
//

#include "stdafx.h"
#include "nome.h"
#include "ColorButton.h"


// CColorButton

IMPLEMENT_DYNAMIC(CColorButton, CButton)
CColorButton::CColorButton()
{
	m_BkColor = GetSysColor(COLOR_BTNFACE);
	m_TextColor = GetSysColor(COLOR_BTNTEXT);
}

CColorButton::~CColorButton()
{
}


BEGIN_MESSAGE_MAP(CColorButton, CButton)
END_MESSAGE_MAP()



// CColorButton message handlers

void CColorButton::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
   UINT uStyle = DFCS_BUTTONPUSH;

   // This code only works with buttons.
   ASSERT(lpDrawItemStruct->CtlType == ODT_BUTTON);

   // If drawing selected, add the pushed style to DrawFrameControl.
   if (lpDrawItemStruct->itemState & ODS_SELECTED)
      uStyle |= DFCS_PUSHED;

   // Draw the button frame.
   ::DrawFrameControl(lpDrawItemStruct->hDC, &lpDrawItemStruct->rcItem, 
      DFC_BUTTON, uStyle);

    CClientDC dc(this);
    CRect rect;
	GetClientRect(&rect);
	rect.DeflateRect(2,2);
	dc.FillSolidRect(&rect,	m_BkColor);
	
   // Get the button's text.
   CString strText;
   GetWindowText(strText);

   // Draw the button text using the text color red.
	int oldmode = ::SetBkMode(lpDrawItemStruct->hDC, TRANSPARENT);
   COLORREF crOldColor = ::SetTextColor(lpDrawItemStruct->hDC, m_TextColor);
   ::DrawText(lpDrawItemStruct->hDC, strText, strText.GetLength(), 
      &lpDrawItemStruct->rcItem, DT_SINGLELINE|DT_VCENTER|DT_CENTER);
	::SetTextColor(lpDrawItemStruct->hDC, crOldColor);
	::SetBkMode(lpDrawItemStruct->hDC, oldmode);
}
void CColorButton::SetBkColor(COLORREF color)
{
	m_BkColor = color;
	Invalidate(FALSE);
}
void CColorButton::SetTextColor(COLORREF color)
{
	m_TextColor = color;
	Invalidate(FALSE);
}