/*
-- Program : NOME
-- Author : Nguoc Tran Nguyen
-- Email : nome-feedback@lexum.umontreal.ca
-- Creation date : 2005-11-07

Copyright (C) 2005 LexUM, RALI - Universit de Montral

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details. http://www.gnu.org/copyleft/gpl.html

You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/ 

// SXButton.cpp : implementation file
// Michael Santoro - msantoro@telerama.lm.com
//
//	Revision History
//	================
//	08-30-97	msantoro	Origional Code
//	11-09-97	msantoro	Added bitmap support
//  11-12-97	msantoro	Fixed drawing of too many focused buttons
//  05-18-98    saubrecht	Resource Cleanup
/////////////////////////////////////////////////////////////////////////////

// CSXButton window

#ifndef _SXBUTTON_H
#define _SXBUTTON_H

#define	SXBUTTON_CENTER	-1

class CSXButton : public CButton
{
// Construction
public:
	CSXButton();

// Attributes
private:
	//	Positioning
	BOOL		m_bUseOffset;				
	CPoint		m_pointImage;
	CPoint		m_pointText;
	int			m_nImageOffsetFromBorder;
	int			m_nTextOffsetFromImage;

	//	Image
	HICON		m_hIcon;					
	HBITMAP		m_hBitmap;
	HBITMAP		m_hBitmapDisabled;
	int			m_nImageWidth, m_nImageHeight;

	//	Color Tab
	char		m_bColorTab;				
	COLORREF	m_crColorTab;

	//	State
	BOOL		m_bDefault;
	UINT		m_nOldAction;
	UINT		m_nOldState;
	

// Operations
public:
	//	Positioning
	int		SetImageOffset( int nPixels ); 
	int		SetTextOffset( int nPixels );
	CPoint	SetImagePos( CPoint p );
	CPoint	SetTextPos( CPoint p );

	//	Image
	BOOL	SetIcon( UINT nID, int nWidth, int nHeight );
	BOOL	SetBitmap( UINT nID, int nWidth, int nHeight );
	BOOL	SetMaskedBitmap( UINT nID, int nWidth, int nHeight, COLORREF crTransparentMask );
	BOOL	HasImage() { return (BOOL)( m_hIcon != 0  | m_hBitmap != 0 ); }

	//	Color Tab
	void	SetColorTab(COLORREF crTab);

	//	State
	BOOL	SetDefaultButton( BOOL bState = TRUE );

private:
	BOOL	SetBitmapCommon( UINT nID, int nWidth, int nHeight, COLORREF crTransparentMask, BOOL bUseMask );
	void	CheckPointForCentering( CPoint &p, int nWidth, int nHeight );
	void	Redraw();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSXButton)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CSXButton();

	// Generated message map functions
protected:
	//{{AFX_MSG(CSXButton)
	afx_msg LRESULT OnGetText(WPARAM wParam, LPARAM lParam);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

#endif
/////////////////////////////////////////////////////////////////////////////
