/*
-- Program : NOME
-- Author : Nguoc Tran Nguyen
-- Email : nome-feedback@lexum.umontreal.ca
-- Creation date : 2005-11-07

Copyright (C) 2005 LexUM, RALI - Universit de Montral

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details. http://www.gnu.org/copyleft/gpl.html

You should have received a copy of the GNU General Public License along with this program;
if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/ 

// NomeTabDlg.cpp : fichier d'implmentation
//

#include "stdafx.h"
#include "nome.h"
#include "NomeTabDlg.h"
#include "MyGrid.h"
#include ".\nometabdlg.h"
#include "NewCellTypes/GridCellCheck.h"
#include "NewCellTypes/GridCellCombo.h"

extern NOTIFYNOME notifyNome;
extern INVOKENOME invokeNome;
// Bote de dialogue CNomeTabDlg
int nomeMsg;
UINT nomeThread( LPVOID pParam )
{
	CNomeTabDlg* pDlg = (CNomeTabDlg*) pParam;
	::invokeNome(nomeMsg, pDlg->id, -1);
	return 0;
}
IMPLEMENT_DYNAMIC(CNomeTabDlg, CDialog)
CNomeTabDlg::CNomeTabDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNomeTabDlg::IDD, pParent)
{
	id = NULL;
}

CNomeTabDlg::~CNomeTabDlg()
{
	m_Replacement.DestroyWindow();
	m_Setting.DestroyWindow();
}

void CNomeTabDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB_NOME, m_Tab);
}
BEGIN_MESSAGE_MAP(CNomeTabDlg, CDialog)
	ON_WM_SIZE()
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_NOME, On)
	ON_WM_CLOSE()
	ON_WM_MOVE()
END_MESSAGE_MAP()
// Gestionnaires de messages CNomeTabDlg

BOOL CNomeTabDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	m_Replacement.Create(IDD_REPLACEMENT, this);
	m_Replacement.ShowWindow(SW_HIDE);	
	m_Replacement.SetWindowText("Replacement");
	m_Tab.addDialog(&m_Replacement);
	m_Setting.Create(IDD_SETTING, this);
	m_Setting.ShowWindow(SW_HIDE);
	m_Setting.SetWindowText("Setting");
	m_Tab.addDialog(&m_Setting);
	m_Replacement.SetParent(this); 
	m_Setting.SetParent(this); 
	m_Tab.activateTab();
	changeLang(NOME_ENGLISH);
	return true;
}

void CNomeTabDlg::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);
	if (m_Tab.m_hWnd != NULL) m_Tab.MoveWindow(0,0,cx,cy,1);
	m_Tab.activateTab();
	if ((notifyNome != NULL)&&(id !=NULL))
		notifyNome(WM_SIZE, id);
}

void CNomeTabDlg::On(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO : ajoutez ici le code de votre gestionnaire de notification de contrle
	*pResult = 0;
}
int CNomeTabDlg::addRow(int nCounts, LPTSTR words, LPTSTR replacement, int type)
{
	return m_Replacement.addRow(nCounts, words, replacement,type);
}
void CNomeTabDlg::OnClose()
{
	// TODO : ajoutez ici le code de votre gestionnaire de messages et/ou les paramtres par dfaut des appels	
	CDialog::OnClose();
	if ((notifyNome != NULL)&&(id != NULL))
		notifyNome(WM_CLOSE, id);
}
SAFEARRAY* CNomeTabDlg::getSelectedNamesKeys(BOOLEAN deleted = false)
{
	int n = m_Replacement.m_Grid.GetRowCount();
	int* pos = new int[n];
	int counter = 0;
	for(int index =1; index < n; index++){
		CGridCellCheck * pCell = (CGridCellCheck*)m_Replacement.m_Grid.GetCell(index, 1);
		if (pCell->GetCheck()){
			pos[counter] = index;
			counter++;
		}
	}

	SAFEARRAY* keys;
	SAFEARRAYBOUND rgsabound;
	rgsabound.lLbound = 0;
	rgsabound.cElements = counter;
	keys = SafeArrayCreate(VT_BSTR, 1, &rgsabound);
	if(keys == NULL) return NULL;
	long i = 0;
	
	for(i = 0; i < counter; i++){
		SafeArrayPutElement(keys, &i,
			m_Replacement.m_Grid.GetItemText(pos[i], 3).AllocSysString());
	}

	if (deleted){
		m_Replacement.m_Grid.SetRedraw(false, false);
		for(index = counter - 1; index >=0 ; index--){
			m_Replacement.m_Grid.DeleteRow(pos[index]);
		}
		m_Replacement.m_Grid.SetRedraw(true, true);
	}
	delete pos;
	return keys;
}

void CNomeTabDlg::deleteSelectedRows()
{
	int n = m_Replacement.m_Grid.GetRowCount();
	int* pos = new int[n];
	int counter = 0;
	for(int index =1; index < n; index++){
		CGridCellCheck* pCell = (CGridCellCheck*)m_Replacement.m_Grid.GetCell(index, 0);
		if (pCell->IsSelected()){
			pos[counter] = index;
			counter ++;
		}
	}
	m_Replacement.m_Grid.SetRedraw(false, false);
	for(index = counter - 1; index >=0; index--){
		m_Replacement.m_Grid.DeleteRow(pos[index] - index);
	}
	m_Replacement.m_Grid.SetRedraw(true, true);
	delete pos;
}
BOOL CNomeTabDlg::isNameChecked(int row)
{
	CGridCellCheck* pCell = (CGridCellCheck*)m_Replacement.m_Grid.GetCell(row, 0);	
	return pCell->GetCheck();
}
SAFEARRAY* CNomeTabDlg::getSelectedNamesPos(int type, BOOLEAN deleted = false)
{
	int n = m_Replacement.m_Grid.GetRowCount();
	int* pos = new int[n];
	int counter = 0;
	for(int index =1; index < n; index++){
		CGridCellCheck* pCell = (CGridCellCheck*)m_Replacement.m_Grid.GetCell(index, 2);
		if (type == 0){
			if (pCell->GetCheck()){
				pos[counter] = index;
				counter++;
			}
		}
		else if (type == 1){
			if ((m_Replacement.m_Grid.GetCell(index, 0)->GetState()& GVIS_SELECTED)||
				(m_Replacement.m_Grid.GetCell(index, 3)->GetState()& GVIS_SELECTED)||
				(m_Replacement.m_Grid.GetCell(index, 4)->GetState()& GVIS_SELECTED)){
				pos[counter] = index;
				counter++;
			}
		}
		else if (type ==2){//return all elements selected
			pos[counter] = index;
			counter++;
		}
	}
	SAFEARRAY* keys;
	SAFEARRAYBOUND rgsabound;
	rgsabound.lLbound = 0;
	rgsabound.cElements = counter;
	keys = SafeArrayCreate(VT_I4, 1, &rgsabound);
	if(keys == NULL) return NULL;
	long i = 0;
	for(i = 0; i < counter; i++){
			SafeArrayPutElement(keys, &i, (void*)&pos[i]);
	}
	
	if (deleted){
		m_Replacement.m_Grid.SetRedraw(false, false);
		for(index = counter - 1; index >=0 ; index--){
			m_Replacement.m_Grid.SetItemState(pos[index],0,0);
			m_Replacement.m_Grid.SetItemState(pos[index],1,0);
			m_Replacement.m_Grid.SetItemState(pos[index],2,0);
			m_Replacement.m_Grid.DeleteRow(pos[index]);
		}
		m_Replacement.m_Grid.SetRedraw(true, true);
	}

	delete pos;
	return keys;
}
int CNomeTabDlg::setProgressPos(LPTSTR status, int pos)
{
	return m_Progress.setProgressPos(status, pos);
}
int CNomeTabDlg::invokeNome(int msg, int param1)
{
	int ret = 0;
	if (msg == NOME_ANALYZE){
		m_Progress.Create(IDD_PROGRESS_NOME, this);
		m_Progress.ShowWindow(SW_SHOW); 
	}
	if (::invokeNome != NULL){
		ret = ::invokeNome(msg,id,param1);
	}
	if (msg == NOME_ANALYZE)
		m_Progress.DestroyWindow();

	if (msg == NOME_REMOVE)
		m_Replacement.m_Grid.Refresh();
	return ret;
}
void CNomeTabDlg::OnMove(int x, int y)
{
	CDialog::OnMove(x, y);
	if (notifyNome != NULL)
		notifyNome(WM_MOVE, id);
	// TODO: Add your message handler code here
}
void CNomeTabDlg::changeLang(int lang)
{
	m_Setting.changeLang(lang);
	m_Replacement.changeLang(lang);
	m_Tab.changeLang(lang);
	this->lang = lang;
}
int CNomeTabDlg::findName(LPTSTR name, int col)
{
	int n = m_Replacement.m_Grid.GetRowCount();
	for(int index =1; index < n; index++){	
		CGridCellBase* pCell = m_Replacement.m_Grid.GetCell(index, col);
		if (_tcscmp(pCell->GetText(), _T(name))==0){
			return index;
		}
	}
}
int CNomeTabDlg::getAutoSize()
{
	RECT rect;
	int width = m_Replacement.m_Grid.GetVirtualWidth();
	m_Replacement.GetWindowRect(&rect);
	m_Replacement.GetParent()->ScreenToClient(&rect);
	width += 2*rect.left;
	GetWindowRect(&rect);
	width = width + 2*GetSystemMetrics(SM_CXVSCROLL);
	if (width < 390) width = 390;
	return width;
}
void CNomeTabDlg::changeRepLang(int lang)
{
	m_Setting.changeRepLang(lang);
	invokeNome(NOME_SET_REP_LANG, lang);
	this->repLang = lang;
}